/*
 * Decompiled with CFR 0.152.
 */
package org.blocovermelho.ae2emicrafting.client.handler.generic;

import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.items.CraftingTermMenu;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.EmiRecipeHandler;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5684;
import org.blocovermelho.ae2emicrafting.client.Ae2EmiMod;
import org.blocovermelho.ae2emicrafting.client.helper.InventoryUtils;
import org.blocovermelho.ae2emicrafting.client.helper.rendering.Result;
import org.jetbrains.annotations.Nullable;

public abstract class Ae2BaseRecipeHandler<T extends AEBaseMenu>
implements EmiRecipeHandler<T> {
    public static final int CRAFTING_GRID_WIDTH = 3;
    public static final int CRAFTING_GRID_HEIGHT = 3;
    private final Class<T> containerClass;

    protected Ae2BaseRecipeHandler(Class<T> containerClass) {
        this.containerClass = containerClass;
    }

    public EmiPlayerInventory getInventory(class_465<T> screen) {
        if (!Ae2EmiMod.cfg.bomsync) {
            return new EmiPlayerInventory(List.of());
        }
        AEBaseMenu handler = (AEBaseMenu)screen.method_17577();
        if (handler instanceof MEStorageMenu) {
            MEStorageMenu menu = (MEStorageMenu)handler;
            class_2371 allStack = class_2371.method_10211();
            List<EmiStack> meSystem = InventoryUtils.getExistingStacks(menu);
            allStack.addAll(meSystem);
            List<EmiStack> hotbar = InventoryUtils.getStacks(screen, SlotSemantics.PLAYER_HOTBAR);
            allStack.addAll(hotbar);
            List<EmiStack> inventory = InventoryUtils.getStacks(screen, SlotSemantics.PLAYER_INVENTORY);
            allStack.addAll(inventory);
            if (menu instanceof CraftingTermMenu) {
                List<EmiStack> craft = InventoryUtils.getStacks(screen, SlotSemantics.CRAFTING_GRID);
                allStack.addAll(craft);
            }
            return new EmiPlayerInventory((List)allStack);
        }
        return EmiPlayerInventory.of((class_1657)handler.getPlayer());
    }

    protected abstract Result transferRecipe(T var1, @Nullable class_1860<?> var2, EmiRecipe var3, boolean var4);

    protected final Result transferRecipe(EmiRecipe emiRecipe, EmiCraftContext<T> context, boolean doTransfer) {
        if (!this.containerClass.isInstance(context.getScreenHandler())) {
            return Result.createNotApplicable();
        }
        class_1860 recipe = ((AEBaseMenu)context.getScreenHandler()).getPlayer().method_37908().method_8433().method_8130(emiRecipe.getId()).orElse(null);
        AEBaseMenu menu = (AEBaseMenu)this.containerClass.cast(context.getScreenHandler());
        Result result = this.transferRecipe(menu, recipe, emiRecipe, doTransfer);
        if (result instanceof Result.Success && doTransfer) {
            class_310.method_1551().method_1507((class_437)context.getScreen());
        }
        return result;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return true;
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<T> context) {
        return this.transferRecipe(recipe, context, false).canCraft();
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<T> context) {
        return this.transferRecipe(recipe, context, true).canCraft();
    }

    public List<class_5684> getTooltip(EmiRecipe recipe, EmiCraftContext<T> context) {
        List<class_2561> tooltip = this.transferRecipe(recipe, context, false).getTooltip(recipe, context);
        if (tooltip != null) {
            return tooltip.stream().map(class_2561::method_30937).map(class_5684::method_32662).toList();
        }
        return super.getTooltip(recipe, context);
    }

    public void render(EmiRecipe recipe, EmiCraftContext<T> context, List<Widget> widgets, class_332 draw) {
        this.transferRecipe(recipe, context, false).render(recipe, context, widgets, draw);
    }
}

